<?php

namespace App\Filament\Resources;

use App\Filament\Resources\PurchasingResource\Pages;
use App\Filament\Resources\PurchasingResource\RelationManagers;
use App\Filament\Resources\PurchasingResource\RelationManagers\PurchasingItemsRelationManager;
use App\Models\Purchasing;
use App\Models\Supplier;
use Filament\Forms;
use Filament\Forms\Form;
use Filament\Resources\Resource;
use Filament\Tables;
use Filament\Tables\Table;
use Illuminate\Database\Eloquent\Builder;
use Illuminate\Database\Eloquent\SoftDeletingScope;

class PurchasingResource extends Resource
{
    protected static ?string $model = Purchasing::class;

    protected static ?string $navigationIcon = 'heroicon-o-document-text';
    protected static ?string $navigationLabel = 'Purchasing';
    protected static ?string $navigationGroup = 'Purchasing';
    protected static ?string $modelLabel = 'Purchasing';

    public static function form(Form $form): Form
    {
        return $form
            ->schema([
                Forms\Components\TextInput::make('po_number')
                    ->disabled()
                    ->dehydrated()
                    ->disabled(fn ($livewire) => $livewire->isLocked),
                Forms\Components\Select::make('supplier_id')
                    ->label('Supplier')
                    ->relationship('supplier', 'name')
                    ->searchable()
                    ->required()
                    ->disabled(fn ($livewire) => $livewire->isLocked),
                Forms\Components\DatePicker::make('po_date')
                    ->required()
                    ->disabled(fn ($livewire) => $livewire->isLocked),
                Forms\Components\Select::make('status')
                    ->options([
                        'Draft' => 'Draft',
                        'Approved' => 'Approved',
                        'Received' => 'Received',
                    ])
                    ->default('Draft')
                    ->required()
                    ->disabled(fn ($livewire) => $livewire->isLocked),
            ]);
    }

    public static function table(Table $table): Table
    {
        return $table
            ->columns([
                Tables\Columns\TextColumn::make('po_number')->searchable()->sortable(),
                Tables\Columns\TextColumn::make('supplier.name')->label('Supplier')->sortable()->searchable(),
                Tables\Columns\TextColumn::make('po_date')->date()->sortable(),
                Tables\Columns\BadgeColumn::make('status')
                    ->colors([
                        'gray' => 'Draft',
                        'info' => 'Approved',
                        'success' => 'Received',
                    ]),
                Tables\Columns\TextColumn::make('purchasingItems_count')
                    ->label('Item Count')
                    ->counts('purchasingItems'),
                Tables\Columns\TextColumn::make('created_at')->dateTime()->label('Created'),
            ])
            ->filters([])
            ->actions([
                Tables\Actions\EditAction::make(),
            ])
            ->bulkActions([
                Tables\Actions\DeleteBulkAction::make(),
            ]);
    }

    public static function getRelations(): array
    {
        return [
            PurchasingItemsRelationManager::class,
        ];
    }

    public static function getPages(): array
    {
        return [
            'index' => Pages\ListPurchasings::route('/'),
            'create' => Pages\CreatePurchasing::route('/create'),
            'edit' => Pages\EditPurchasing::route('/{record}/edit'),
        ];
    }
}
