<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Factories\HasFactory;

class Purchasing extends Model
{
    use HasFactory;

    protected $fillable = ['po_number', 'supplier_id', 'po_date', 'status'];

    public function supplier()
    {
        return $this->belongsTo(Supplier::class);
    }

    public function purchasingItems()
    {
        return $this->hasMany(PurchasingItem::class);
    }
}
