<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Factories\HasFactory;

class Sales extends Model
{
    use HasFactory;

    protected $fillable = ['invoice_number', 'customer_name', 'sale_date', 'payment_method'];

    public function items()
    {
        return $this->hasMany(SalesItem::class, 'sale_id');
    }

    public function getRouteKeyName(): string
    {
        return 'id';
    }
}
