<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('purchasings', function (Blueprint $table) {
            $table->id();
            $table->string('po_number')->unique();
            $table->foreignId('supplier_id')->constrained()->cascadeOnDelete();
            $table->date('po_date');
            $table->enum('status', ['Draft', 'Approved', 'Received'])->default('Draft');
            $table->timestamps();
        });

        Schema::create('purchasing_items', function (Blueprint $table) {
            $table->id();
            $table->foreignId('purchasing_id')->constrained()->cascadeOnDelete();
            $table->string('name');
            $table->integer('quantity');
            $table->decimal('purchasing_price', 12, 2);
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('purchasing_items');
        Schema::dropIfExists('purchasings');
    }
};
